// Imports
import java.util.*;
import javax.xml.bind.*;
import java.math.*;

// Java classes generated from schema
import us.ny.state.wcb.xml.ns.wcb.*;
import us.ny.state.wcb.xml.ns.cms1500_1202.Data.*;

/**
 * <p>Title: XFS Sample Code</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2008</p>
 * <p>Company: New York State Workers' Compensation Board</p>
 * @author Patrick J. Maloney
 * @version 4.0
 */

public class XFSCreateXMLFile {
  public XFSCreateXMLFile() {
  }

  public static void main(String[] args) {
    XFSCreateXMLFile XFSCreateXMLFile1 = new XFSCreateXMLFile();

    XFSCreateXMLFile1.createFile();
  }

  public void createFile() {
    // Set up submission file
    us.ny.state.wcb.xml.ns.wcb.ObjectFactory wcbObjFactory = new us.ny.state.wcb.xml.ns.wcb.ObjectFactory();

    try {
      // Create some constants
      // Gender
      Gender genderMale = wcbObjFactory.createGender();
      genderMale.setValue("M");
      Gender genderFemale = wcbObjFactory.createGender();
      genderFemale.setValue("F");

      // Flag Type (for elements that only allow Y or N)
      Flag flagY = wcbObjFactory.createFlag();
      flagY.setValue("Y");
      Flag flagN = wcbObjFactory.createFlag();
      flagN.setValue("N");

      // FlagUnknown Type (for elements that allow Y, N, or U)
      FlagUnknown flagUnknownY = wcbObjFactory.createFlagUnknown();
      flagUnknownY.setValue("Y");
      FlagUnknown flagUnknownN = wcbObjFactory.createFlagUnknown();
      flagUnknownN.setValue("N");
      FlagUnknown flagUnknownU = wcbObjFactory.createFlagUnknown();
      flagUnknownU.setValue("U");

      // Instantiate the one and only one submission object which contains all documents
      Submission sub = wcbObjFactory.createSubmission();

      // Elements noted as REQUIRED in the comments must always contain data.
      // Elements noted as CONDITIONALLY REQUIRED in the comments must contain data as idenified in the C-4NARR requirements/edits document
      //     on the WCB web site.
      // Elements notes as OPTIONAL are never required, but should be populated if the data is available.  All of the optional item 'set'
      //     methods are present in this sample code for documentation purposes, but some have been commented out since there is no sample
      //     data for them.  However, if the data is available for an optional item, its 'set' method should be called to populate it.

      // Set submission attributes
      // REQUIRED - Fixed value
      sub.setApplicationId("CIS");

      // REQUIRED - T for Test, P for Production
      sub.setProductionTestIndicator("T");

      // REQUIRED - This is the submitter's identification code -- the results XML file will contain this code
      sub.setBpSubmissionId("XYZ001");

      // OPTIONAL - Comment for submitter's use
      sub.setBpSubmissionComment("This submission was created on 7/15/2021.");

      // At this point, a database query or other retrieval would occur to get the data required for all documents

      // Loop through that data to create the actual documents (1000 documents maximum per submission)
//      for (int i = 0; i < 4; i++) { // Generate all sample documents
      for (int i = 0; i < 1; i++) { // Generate only CMS-1500 sample document
        // For sample purposes, create a CMS-1500 document on the first iteration, create a C-4NARR document on the
        // second iteration of the loop, a C-4AMR document on the third iteration, and an OT/PT-4 on the fourth iteration

        switch (i) {
          case 0: {
            // CMS-1500

            // NOTE:  For the CMS-1500 sample here, any element identified as REQUIRED must ALWAYS be present.  Any element identified as OPTIONAL may be conditionally required.
            //        Refer to the CMS-1500 Field Table Matrix on the WCB web site for more information on conditionally required elements.

            // Create some constants
            // Relationship to Insured
            us.ny.state.wcb.xml.ns.cms1500_1202.Data.Patient.RelationshipToInsured relationshipToInsuredOther = new us.ny.state.wcb.xml.ns.cms1500_1202.Data.Patient.RelationshipToInsured();
            relationshipToInsuredOther.setValue(BigInteger.valueOf(4));

            // Object Factory (CMS-1500)
            us.ny.state.wcb.xml.ns.cms1500_1202.ObjectFactory objFactory = new us.ny.state.wcb.xml.ns.cms1500_1202.ObjectFactory();

            // Instantiate a single Document object (which contains discrete data and one or more attachment objects)
            us.ny.state.wcb.xml.ns.cms1500_1202.Document document = objFactory.createDocument();

            // Attach the document to the submission
            sub.getDocumentOrDocumentOrDocument().add(document);

            // Set the document's attributes

            // REQUIRED - Submitter's document identification code (must be unique within the submission)
            document.setBpDocumentId("DOC00" + (i + 1));

            // OPTIONAL - Document level comment for submitter's use
            document.setBpDocumentComment("Patient: Joe Smith");

            // Start of discrete data for CMS-1500

            // Instantiate the Document's Data object
            us.ny.state.wcb.xml.ns.cms1500_1202.Data data = objFactory.createData();

            // Attach the data object to the document
            document.setData(data);

            // Set the data object's attributes

            // REQUIRED - Fixed value
            data.setFormId("CMS-1500");

            // REQUIRED - Fixed value
            data.setVersionNumber("1202");

            // Set the CMS-1500 data object's properties

            // Carrier

            // Instantiate the Carrier object
            us.ny.state.wcb.xml.ns.cms1500_1202.Data.Carrier carrier = objFactory.createDataCarrier();

            // Attach it to the data object
            data.setCarrier(carrier);

            // Now, set the Carrier data

            // OPTIONAL - WCB Carrier ID
            carrier.setWcbCarrierId("W204002");

            // Payer

            // Instantiate the Payer object
            us.ny.state.wcb.xml.ns.cms1500_1202.Data.Payer payer = objFactory.createDataPayer();

            // Attach it to the data object
            data.setPayer(payer);

            // Now, set the Payer data

            // REQUIRED - Payer Name
            payer.setName("State Insurance Fund");

            // OPTIONAL - Payer Address Line 1
//            payer.setAddr1("");

            // OPTIONAL - Payer Address Line 2
//            payer.setAddr2("");

            // OPTIONAL - Payer City, State, and Zip
//            payer.setCityStateZip("");

            // Patient

            // Instantiate the Patient object
            us.ny.state.wcb.xml.ns.cms1500_1202.Data.Patient patient = objFactory.createDataPatient();

            // Attach it to the data object
            data.setPatient(patient);

            // Now, set the Patient data

            // Patient Name and Address - Instantiate the Patient Name and Address Object
            us.ny.state.wcb.xml.ns.cms1500_1202.Data.Patient.NameAddress patientNameAddress = objFactory.createDataPatientNameAddress();

            // Attach it to the patient object
            patient.setNameAddress(patientNameAddress);

            // Populate Patient Name and Address items

            // REQUIRED - Patient Last Name, First Name, Middle Initial
            patientNameAddress.setLastNameFirstNameMiddleInitial("Smith, Joe");

            // REQUIRED - Patient Address
            patientNameAddress.setAddress("123 Happy St.");

            // REQUIRED - Patient City
            patientNameAddress.setCity("Albany");

            // REQUIRED - Patient State
            patientNameAddress.setState("NY");

            // REQUIRED - Patient Zip
            patientNameAddress.setZip("12345");

            // OPTIONAL - Patient Telephone
            if (true) {
              // If the telephone object is attached to the name and address object, REQUIRED elements identified below must be present

              // Instantiate the Patient Telephone object
              us.ny.state.wcb.xml.ns.cms1500_1202.Data.Patient.NameAddress.Telephone patientTelephone = objFactory.createDataPatientNameAddressTelephone();

              // Attach it to the Patient Name and Address object
              patientNameAddress.setTelephone(patientTelephone);

              // Populate Patient Telephone items

              // REQUIRED - Patient Telephone Area Code
              patientTelephone.setAreaCode("518");

              // REQUIRED - Patient Telephone Phone Number
              patientTelephone.setPhoneNumber("5551234");
            }

            // REQUIRED - Patient Date of Birth
            patient.setDateOfBirth(new Date());

            // OPTIONAL - Patient Gender
            patient.setGender(genderMale);

            // REQUIRED - Patient Relationship to Insured
            patient.setRelationshipToInsured(relationshipToInsuredOther);

            // REQUIRED - Patient Employment Flag
            us.ny.state.wcb.xml.ns.cms1500_1202.Data.Patient.EmploymentFlag employmentFlag = new us.ny.state.wcb.xml.ns.cms1500_1202.Data.Patient.EmploymentFlag();
            employmentFlag.setValue("Y");
            patient.setEmploymentFlag(employmentFlag);

            // REQUIRED - Patient Auto Accident Flag
            us.ny.state.wcb.xml.ns.cms1500_1202.Data.Patient.AutoAccidentFlag autoAccidentFlag = new us.ny.state.wcb.xml.ns.cms1500_1202.Data.Patient.AutoAccidentFlag();
            patient.setAutoAccidentFlag(autoAccidentFlag);
            autoAccidentFlag.setValue("Y");
            // If value is 'Y', place must be set to state code where accident occurred
            autoAccidentFlag.setPlace("NY");

            // REQUIRED - Patient Other Accident Flag
            patient.setOtherAccidentFlag(flagN);

            // OPTIONAL - Patient Claim Codes
//            patient.setClaimCodes("");

            // REQUIRED - Patient Date of Current Illness, Injury, or Pregnancy (LMP)
            us.ny.state.wcb.xml.ns.cms1500_1202.Data.Patient.DateOfCurrentIllnessInjuryOrPregnancy dateCurrentIllness = new us.ny.state.wcb.xml.ns.cms1500_1202.Data.Patient.DateOfCurrentIllnessInjuryOrPregnancy();
            patient.setDateOfCurrentIllnessInjuryOrPregnancy(dateCurrentIllness);

            // REQUIRED - Patient Date of Current Illness, Injury, or Pregnancy (LMP) - Qualifier
            dateCurrentIllness.setQualifier("431");

            // REQUIRED - Patient Date of Current Illness, Injury, or Pregnancy (LMP) - Date
            dateCurrentIllness.setDate("2021-06-20");

            // OPTIONAL - Patient Other Date
            if (false) {
              // If the other date is attached to the patient object, REQUIRED elements identified below must be present

              // Instantiate the Patient Other Date object
              us.ny.state.wcb.xml.ns.cms1500_1202.Data.Patient.OtherDate otherDate = new us.ny.state.wcb.xml.ns.cms1500_1202.Data.Patient.OtherDate();

              // Attach it to the patient object
              patient.setOtherDate(otherDate);

              // REQUIRED - Patient Other Date - Qualifier
              otherDate.setQualifier("454");

              // REQUIRED - Patient Other Date - Date
              otherDate.setDate(new Date());
            }

            // OPTIONAL - Patient Dates Patient Unable to Work in Current Occupation
            if (false) {
              // If the dates unable to work is attached to the patient object, REQUIRED elements identified below must be present

              // Instantiate the Patient Dates Patient Unable to Work in Current Occupation object
              us.ny.state.wcb.xml.ns.cms1500_1202.Data.Patient.DatesPatientUnableToWorkInCurrentOperation datesUnableToWork = new us.ny.state.wcb.xml.ns.cms1500_1202.Data.Patient.DatesPatientUnableToWorkInCurrentOperation();

              // Attach it to the patient object
              patient.setDatesPatientUnableToWorkInCurrentOperation(datesUnableToWork);

              // REQUIRED - Patient Dates Patient Unable to Work in Current Occupation - From Date
              datesUnableToWork.setFromDate(new Date());

              // REQUIRED - Patient Dates Patient Unable to Work in Current Occupation - To Date
              datesUnableToWork.setToDate(new Date());
            }

            // OPTIONAL - Patient Signature
            if (false) {
              // If the signature is attached to the patient object, REQUIRED elements identified below must be present

              // Instantiate the Signature object
              us.ny.state.wcb.xml.ns.cms1500_1202.Data.Patient.Signature signature = new us.ny.state.wcb.xml.ns.cms1500_1202.Data.Patient.Signature();

              // Attach it to the patient object
              patient.setSignature(signature);

              // REQUIRED - Patient Signature - Signed Name
              signature.setSignedName("Joe Smith");

              // OPTIONAL - Patient Signature - Signed Date
//              signature.setSignedDate(new Date());
            }

            // Insured

            // Instantiate the Insured object
            us.ny.state.wcb.xml.ns.cms1500_1202.Data.Insured insured = objFactory.createDataInsured();

            // Attach it to the data object
            data.setInsured(insured);

            // Now, set the Insured data

            // REQUIRED - Insurance Program (must be 7)
            us.ny.state.wcb.xml.ns.cms1500_1202.Data.Insured.Program program = new us.ny.state.wcb.xml.ns.cms1500_1202.Data.Insured.Program();
            program.setValue(BigInteger.valueOf(7));
            insured.setProgram(program);

            // OPTIONAL - Insured's ID Number
//            insured.setIdNumber("");

            // Insured Name and Address - Instantiate the Insured Name and Address Object
            us.ny.state.wcb.xml.ns.cms1500_1202.Data.Insured.NameAddress insuredNameAddress = objFactory.createDataInsuredNameAddress();

            // Attach it to the patient object
            insured.setNameAddress(insuredNameAddress);

            // Populate Insured Name and Address items

            // REQUIRED - Insured Last Name, First Name, Middle Initial
            insuredNameAddress.setLastNameFirstNameMiddleInitial("Smith, Joe");

            // OPTIONAL - Insured Address
            insuredNameAddress.setAddress("123 Happy St.");

            // OPTIONAL - Insured City
            insuredNameAddress.setCity("Albany");

            // OPTIONAL - Insured State
            insuredNameAddress.setState("NY");

            // OPTIONAL - Insured Zip
            insuredNameAddress.setZip("12345");

            // OPTIONAL - Insured Telephone
            if (true) {
              // If the telephone object is attached to the name and address object, REQUIRED elements identified below must be present

              // Instantiate the Insured Telephone object
              us.ny.state.wcb.xml.ns.cms1500_1202.Data.Insured.NameAddress.Telephone insuredTelephone = objFactory.createDataInsuredNameAddressTelephone();

              // Attach it to the Insured Name and Address object
              insuredNameAddress.setTelephone(insuredTelephone);

              // Populate Insured Telephone items

              // REQUIRED - Insured Telephone Area Code
              insuredTelephone.setAreaCode("518");

              // REQUIRED - Insured Telephone Phone Number
              insuredTelephone.setPhoneNumber("5551234");
            }

            // OPTIONAL - Other Insured
            if (false) {
              // If the other insured object is attached to the insured object, REQUIRED elements identified below must be present

              // Instantiate the Other Insured object
              us.ny.state.wcb.xml.ns.cms1500_1202.Data.Insured.OtherInsured otherInsured = objFactory.createDataInsuredOtherInsured();

              // Attach it to the Insured object
              insured.setOtherInsured(otherInsured);

              // Populate Other Insured items

              // OPTIONAL - Other Insured Last Name, First Name, Middle Initial
//              otherInsured.setLastNameFirstNameMiddleInitial("");

              // OPTIONAL - Other Insured Policy or Group Number
//              otherInsured.setPolicyOrGroupNumber("");

              // OPTIONAL - Other Insured Insurance Plan Name or Program Name
//              otherInsured.setInsurancePlanNameOrProgramName("");
            }

            // OPTIONAL - Insured Insurance Plan Name or Program Name
//            insured.setInsurancePlanNameOrProgramName("");

            // REQUIRED - Insured Another Health Benefit Plan Flag
            insured.setAnotherHealthBenefitPlanFlag(flagN);

            // Reserved Field 9b

            // Instantiate the Reserved Field 9b object
            us.ny.state.wcb.xml.ns.cms1500_1202.Data.ReservedField9B reservedField9B = objFactory.createDataReservedField9B();

            // Attach it to the data object
            data.setReservedField9B(reservedField9B);

            // Now, set the Reserved Field 9b data

            // REQUIRED - Reserved Field 9b Claimant First Name
            reservedField9B.setClaimantFirstName("Joe");

            // REQUIRED - Reserved Field 9b Claimant Last Name
            reservedField9B.setClaimantLastName("Smith");

            // Physician or Suppler

            // Instantiate the Physician or Suppler object
            us.ny.state.wcb.xml.ns.cms1500_1202.Data.PhysicianOrSupplier physicianOrSupplier = objFactory.createDataPhysicianOrSupplier();

            // Attach it to the data object
            data.setPhysicianOrSupplier(physicianOrSupplier);

            // Now, set the Physician or Suppler data

            // OPTIONAL - Referring Provider or Other Source
            if (false) {
              // If the referring provider object is attached to the physician or supplier object, REQUIRED elements identified below must be present

              // Instantiate the Referring Provider or Other Source object
              us.ny.state.wcb.xml.ns.cms1500_1202.Data.PhysicianOrSupplier.ReferringProviderOrOtherSource referringProvider = objFactory.createDataPhysicianOrSupplierReferringProviderOrOtherSource();

              // Attach it to the Physician or Supplier object
              physicianOrSupplier.setReferringProviderOrOtherSource(referringProvider);

              // Populate the Referring Provider or Other Source items

              // REQUIRED - Referring Provider Qualifier
              referringProvider.setQualifier("DK");

              // REQUIRED - Referring Provider Name
              referringProvider.setName("Dr. Richard Jones");

              // OPTIONAL - Referring Provider Other Id Number
              if (true) {
                // If the referring provider other id number object is attached to the referring provider object, REQUIRED elements identified below must be present

                // Instantiate the Referring Provider Other Id Number object
                us.ny.state.wcb.xml.ns.cms1500_1202.Data.PhysicianOrSupplier.ReferringProviderOrOtherSource.OtherIdNumber otherIdNumber = objFactory.createDataPhysicianOrSupplierReferringProviderOrOtherSourceOtherIdNumber();

                // Attach it to the Referring Provider object
                referringProvider.setOtherIdNumber(otherIdNumber);

                // Populate the Referring Provider Other Id Number items

                // REQUIRED - Referring Provider Other Id Number Qualifier - Fixed Value
                otherIdNumber.setQualifier("0B");

                // REQUIRED - Referring Provider Other Id Number Id Number
                otherIdNumber.setIdNumber("123456");
              }

              // OPTIONAL - Referring Provider NPI Number
              referringProvider.setNpiNumber("1234567890");
            }

            // OPTIONAL - Hospitalization Dates Related to Current Services
            if (false) {
              // If the hospitalization dates are attached to the physician or supplier object, REQUIRED elements identified below must be present

              // Instantiate the Hospitalization Dates Related to Current Services object
              us.ny.state.wcb.xml.ns.cms1500_1202.Data.PhysicianOrSupplier.HospitalizationDatesRelatedToCurrentServices hospitalizationDates = new us.ny.state.wcb.xml.ns.cms1500_1202.Data.PhysicianOrSupplier.HospitalizationDatesRelatedToCurrentServices();

              // Attach it to the Physician or Supplier object
              physicianOrSupplier.setHospitalizationDatesRelatedToCurrentServices(hospitalizationDates);

              // REQUIRED - Hospitalization Dates Related to Current Services- From Date
              hospitalizationDates.setFromDate(new Date());

              // REQUIRED - Hospitalization Dates Related to Current Services - To Date
              hospitalizationDates.setToDate(new Date());
            }

            // OPTIONAL - Outside Lab Flag
            us.ny.state.wcb.xml.ns.cms1500_1202.Data.PhysicianOrSupplier.OutsideLabFlag outsideLabFlag = new us.ny.state.wcb.xml.ns.cms1500_1202.Data.PhysicianOrSupplier.OutsideLabFlag();
            physicianOrSupplier.setOutsideLabFlag(outsideLabFlag);
            outsideLabFlag.setValue("Y");
            outsideLabFlag.setCharges(275.64);

            // REQUIRED - Diagnosis or Nature of Illness or Injury
            us.ny.state.wcb.xml.ns.cms1500_1202.Data.PhysicianOrSupplier.DiagnosisOrNatureOfIllnessOrInjury diagnosis = new us.ny.state.wcb.xml.ns.cms1500_1202.Data.PhysicianOrSupplier.DiagnosisOrNatureOfIllnessOrInjury();
            physicianOrSupplier.setDiagnosisOrNatureOfIllnessOrInjury(diagnosis);
            diagnosis.setICDIndicator("0"); // Fixed value

            // Add all diagnosis codes
            for (int k = 0; k < 1; k++) {
              diagnosis.getDiagnosisCode().add("V120.00");
            }

            // OPTIONAL - Resubmission
            if (false) {
              // If the resubmission is attached to the physician or supplier object, REQUIRED elements identified below must be present

              // Instantiate the Resubmission object
              us.ny.state.wcb.xml.ns.cms1500_1202.Data.PhysicianOrSupplier.Resubmission resubmission = new us.ny.state.wcb.xml.ns.cms1500_1202.Data.PhysicianOrSupplier.Resubmission();

              // Attach it to the Physician or Supplier object
              physicianOrSupplier.setResubmission(resubmission);

              // REQUIRED - Resubmission Code
              resubmission.setCode("7");

              // REQUIRED - Resubmission Original Reference Number
              resubmission.setOriginalReferenceNumber("1234567");
            }

            // OPTIONAL - Prior Authorization Number
//            physicianOrSupplier.setPriorAuthorizationNumber("");

            // Procedures, Services, or Supplies

            // Add all procedures
            for (int l = 0; l < 1; l++) {
              // Instantiate a Procedures, Services, or Supplies object
              us.ny.state.wcb.xml.ns.cms1500_1202.Data.PhysicianOrSupplier.ProcedureServiceOrSupply procedure = objFactory.createDataPhysicianOrSupplierProcedureServiceOrSupply();

              // Add it to the list of procedures
              physicianOrSupplier.getProcedureServiceOrSupply().add(procedure);

              // Populate Procedures, Services, or Supplies items

              // OPTIONAL - Supplemental Information
//              procedure.setSupplementalInformation("");

              // REQUIRED - Procedure From Date
              procedure.setFromDate(new Date());

              // REQUIRED - Procedure To Date
              procedure.setToDate(new Date());

              // REQUIRED - Procedure Place of Service
              procedure.setPlaceOfService("11");

              // OPTIONAL - Procedure Emergency Flag
              procedure.setEmergencyFlag(flagN);

              // REQUIRED - Procedure CPT/HCPS Code
              procedure.setCptHcpcsCode("12345");

              // OPTIONAL - Procedure Modifier A
//              procedure.setModifierA("");

              // OPTIONAL - Procedure Modifier B
//              procedure.setModifierB("");

              // OPTIONAL - Procedure Modifier C
//              procedure.setModifierC("");

              // OPTIONAL - Procedure Modifier D
//              procedure.setModifierD("");

              // REQUIRED - Procedure Diagnosis Pointer
              procedure.setDiagnosisPointer("A");

              // REQUIRED - Procedure Charges
              procedure.setCharges(175.00);

              // REQUIRED - Procedure Days or Units
              procedure.setDaysOrUnits("1");

              // OPTIONAL - Rendering Provider ID Number
              if (false) {
                // If the rendering provider id number is attached to the procedure object, REQUIRED elements identified below must be present

              // Instantiate the  Rendering Provider ID Number object
                us.ny.state.wcb.xml.ns.cms1500_1202.Data.PhysicianOrSupplier.ProcedureServiceOrSupply.RenderingProviderIdNumber renderingProviderId = new us.ny.state.wcb.xml.ns.cms1500_1202.Data.PhysicianOrSupplier.ProcedureServiceOrSupply.RenderingProviderIdNumber();

              // Attach it to the Procedures, Services, or Supplies object
                procedure.setRenderingProviderIdNumber(renderingProviderId);

              // REQUIRED - Rendering Provider ID Number Qualifier
                renderingProviderId.setQualifier("0B");

              // REQUIRED - Rendering Provider ID Number Qualifier Id Number
                renderingProviderId.setIdNumber("123456");
              }

              // OPTIONAL - Procedure Rendering Provider NPI Number
              procedure.setRenderingProviderNpiNumber("1234567890");
            }

            // REQUIRED - Federal Tax Id Number
            us.ny.state.wcb.xml.ns.cms1500_1202.Data.PhysicianOrSupplier.FederalTaxIdNumber taxId = new us.ny.state.wcb.xml.ns.cms1500_1202.Data.PhysicianOrSupplier.FederalTaxIdNumber();
            physicianOrSupplier.setFederalTaxIdNumber(taxId);
            taxId.setType(2); // 1 - SSN, 2 - EIN
            taxId.setValue("123456789");

            // REQUIRED - Patient's Account Number
            physicianOrSupplier.setPatientsAccountNo("XYZ123");

            // REQUIRED - Accept Assignment Flag
            us.ny.state.wcb.xml.ns.cms1500_1202.Data.PhysicianOrSupplier.AcceptAssignmentFlag acceptAssignmentFlag = new us.ny.state.wcb.xml.ns.cms1500_1202.Data.PhysicianOrSupplier.AcceptAssignmentFlag();
            physicianOrSupplier.setAcceptAssignmentFlag(acceptAssignmentFlag);
            acceptAssignmentFlag.setValue("Y");

            // REQUIRED - Total Charge
            physicianOrSupplier.setTotalCharge(175.00);

            // OPTIONAL - Amount Paid
//            physicianOrSupplier.setAmountPaid(0.00);

            // REQUIRED - Physician Signature

            // Instantiate the Signature object
            us.ny.state.wcb.xml.ns.cms1500_1202.Data.PhysicianOrSupplier.Signature signaturePhysician = new us.ny.state.wcb.xml.ns.cms1500_1202.Data.PhysicianOrSupplier.Signature();

            // Attach it to the Physician or Supplier object
            physicianOrSupplier.setSignature(signaturePhysician);

            // REQUIRED - Physician Signature - Signed Name
            signaturePhysician.setSignedName("Dr. Richard Jones");

            // REQUIRED - Physician Signature - Signed Date
            signaturePhysician.setSignedDate(new Date());

            // REQUIRED - Service Facility

            // Instantiate the Service Facility object
            us.ny.state.wcb.xml.ns.cms1500_1202.Data.PhysicianOrSupplier.ServiceFacility serviceFacility = new us.ny.state.wcb.xml.ns.cms1500_1202.Data.PhysicianOrSupplier.ServiceFacility();

            // Attach it to the Physician or Supplier object
            physicianOrSupplier.setServiceFacility(serviceFacility);

            // REQUIRED - Service Facility Name
            serviceFacility.setName("Smith Service Facility");

            // REQUIRED - Service Facility Address
            serviceFacility.setAddress("123 Fourth St");

            // REQUIRED - Service Facility City, State, Zip
            serviceFacility.setCityStateZip("Albany, NY 12345");

            // OPTIONAL - Service Facility NPI Number
//            serviceFacility.setNpiNumber("");

            // OPTIONAL - Service Facility Other Id Number
            if (false) {
              // If the service facility other id number object is attached to the service facility object, REQUIRED elements identified below must be present

              // Instantiate the Service Facility Other Id Number object
              us.ny.state.wcb.xml.ns.cms1500_1202.Data.PhysicianOrSupplier.ServiceFacility.OtherIdNumber serviceFacilityOtherIdNumber = objFactory.createDataPhysicianOrSupplierServiceFacilityOtherIdNumber();

              // Attach it to the Service Facility object
              serviceFacility.setOtherIdNumber(serviceFacilityOtherIdNumber);

              // Populate the Service Facility Other Id Number items

              // REQUIRED - Service Facility Other Id Number Qualifier - Fixed Value
              serviceFacilityOtherIdNumber.setQualifier("0B");

              // REQUIRED - Service Facility Other Id Number Id Number
              serviceFacilityOtherIdNumber.setIdNumber("123456");
            }

            // REQUIRED - Billing Provider

            // Instantiate the Billing Provider object
            us.ny.state.wcb.xml.ns.cms1500_1202.Data.PhysicianOrSupplier.BillingProvider billingProvider = new us.ny.state.wcb.xml.ns.cms1500_1202.Data.PhysicianOrSupplier.BillingProvider();

            // Attach it to the Physician or Supplier object
            physicianOrSupplier.setBillingProvider(billingProvider);

            // REQUIRED - Billing Provider Name
            billingProvider.setName("Dr. Richard Jones");

            // REQUIRED - Billing Provider Address
            billingProvider.setAddress("678 Ninth St");

            // REQUIRED - Billing Provider City, State, Zip
            billingProvider.setCityStateZip("Albany, NY 12346");

            // REQUIRED - Billing Provider Telephone

            // Instantiate the Billing Provider Telephone object
            us.ny.state.wcb.xml.ns.cms1500_1202.Data.PhysicianOrSupplier.BillingProvider.Telephone billingProviderTelephone = new us.ny.state.wcb.xml.ns.cms1500_1202.Data.PhysicianOrSupplier.BillingProvider.Telephone();

            // Attach it to the Billing Provider object
            billingProvider.setTelephone(billingProviderTelephone);

            // REQUIRED - Billing Provider Telephone Area Code
            billingProviderTelephone.setAreaCode("518");

            // REQUIRED - Billing Provider Telephone Phone Number
            billingProviderTelephone.setPhoneNumber("5556584");

            // OPTIONAL - Billing Provider NPI Number
//            billingProvider.setNpiNumber("");

            // OPTIONAL - Billing Provider Other Id Number
            if (false) {
              // If the billing provider other id number object is attached to the billing provider object, REQUIRED elements identified below must be present

              // Instantiate the Billing Provider Other Id Number object
              us.ny.state.wcb.xml.ns.cms1500_1202.Data.PhysicianOrSupplier.BillingProvider.OtherIdNumber billingProviderOtherIdNumber = objFactory.createDataPhysicianOrSupplierBillingProviderOtherIdNumber();

              // Attach it to the Billing Provider object
              billingProvider.setOtherIdNumber(billingProviderOtherIdNumber);

              // Populate the Billing Provider Other Id Number items

              // REQUIRED - Billing Provider Other Id Number Qualifier - Fixed Value
              billingProviderOtherIdNumber.setQualifier("0B");

              // REQUIRED - Billing Provider Other Id Number Id Number
              billingProviderOtherIdNumber.setIdNumber("654321");
            }

            // Additional Claim Information

            // Instantiate the Additional Claim Information object
            us.ny.state.wcb.xml.ns.cms1500_1202.Data.AdditionalClaimInformation additionalClaimInformation = objFactory.createDataAdditionalClaimInformation();

            // Attach it to the data object
            data.setAdditionalClaimInformation(additionalClaimInformation);

            // Now, set the Additional Claim Information data

            // OPTIONAL - WCB Authorization Number
//            additionalClaimInformation.setWcbAuthorizationNumber("");

            // OPTIONAL - WCB Rating Code
//            additionalClaimInformation.setWcbRatingCode("");

            // REQUIRED - Report Type Code
            additionalClaimInformation.setReportTypeCode("PWK06");

            // REQUIRED - Transmission Type Code - Fixed value "E"
            additionalClaimInformation.setTransmissionTypeCode("E");

            // REQUIRED - Attachment Control ID
            additionalClaimInformation.setAttachmentControlId("12345");

            // REQUIRED - NTEADD Text - Fixed value "NTEADD"
            additionalClaimInformation.setNteaddTxt("NTEADD");

            // REQUIRED - Carrier Received Date
            additionalClaimInformation.setCarrierReceivedDate(new Date());

            // Start of CMS-1500 Form Images - at least one is required

            // Create one form image
            for (int j = 0; j < 1; j++) {
              // Instantiate the form image object
              FormImage formImage = new FormImage();

              // Add the form image to the current document
              document.getFormImage().add(formImage);

              // Set the form image's attributes

              // REQUIRED - Form Image's MIME Type - Fixed value - only "image/tiff" is currently allowed.
              formImage.setContentType("image/tiff");

              // REQUIRED - Form Image's Reference - This is be the name of the file, included with the submission, that contains the actual
              //            form image.
              formImage.setRef("im00001.tif"); // The file named 'im00001.tif' would have to be included with the submission
            }

            // End of CMS-1500 Form Images

            // Start of Attachments

            // Add one binary attachment

            // Instantiate the binary attachment object
            AttachmentBinary bin = wcbObjFactory.createAttachmentBinary();

            // Add the binary attachment to the current document
            document.getAttachmentTextOrAttachmentBinary().add(bin);

            // Set the binary attachment's attributes

            // REQUIRED - Binary Attachment's MIME Type - Fixed value - only "image/tiff" is currently allowed.
            bin.setContentType("image/tiff");

            // REQUIRED - Binary Attachment's Reference - This is be the name of the file, included with the submission, that contains the actual
            //            binary attachment.
            bin.setRef("im00002.tif"); // The file named 'im00002.tif' would have to be included with the submission

            // Add one text attachment

            // Instantiate the text attachment object
            // A text attachment consists of one or more pages of 56 lines with 100 characters each.  WCB will internally convert each page to an
            // image by printing the lines of text with a fixed space Courier font, so spaces may be used for formatting and this formatting will
            // be preserved.  Blank lines are also allowed.
            AttachmentText txt = wcbObjFactory.createAttachmentText();

            // Add the text attachment to the current document
            document.getAttachmentTextOrAttachmentBinary().add(txt);

            // For sample purposes, create two pages of text

            // Instantiate a page object for page 1 (at least one page is required)
            AttachmentText.Page pg = wcbObjFactory.createAttachmentTextPage();

            // Add page 1 to the text attachment
            txt.getPage().add(pg);

            // Now, add lines of text to page 1 (max of 56 lines per page, max of 100 characters per line)
            // There must be at least one line on each page.
            pg.getLine().add("Patient:");
            pg.getLine().add("Joe Smith");
            pg.getLine().add("123 Fourth St");
            pg.getLine().add("Albany, NY 12241");
            pg.getLine().add(""); // Blank lines allowed to preserve formatting
            pg.getLine().add("The patient fell at work and broke his arm.  It appears to be healing well.");
            pg.getLine().add("I recommend 8 more weeks be allowed for recovery.  100% recovery is expected.");
            pg.getLine().add("And so on and so forth... (the explanation should be as detailed as possible)");

            // Instantiate a page object for page 2 (we can reuse variable 'pg' since we're done with it)
            pg = wcbObjFactory.createAttachmentTextPage();

            // Add page 2 to the text attachment
            txt.getPage().add(pg);

            // Now, add lines of text to page 2 (max of 56 lines per page, max of 100 characters per line)
            // There must be at least one line on each page.
            pg.getLine().add("This is the second page of the text attachment.");
            pg.getLine().add("<>\"'&");

            // Add unlimited additional pages as required...

            // End of Attachments

            // Population of one CMS-1500 document is complete
            break;
          }
          case 1: {
            // C-4NARR

            // Object Factory (C-4NARR)
            us.ny.state.wcb.xml.ns.c4narr_1510.ObjectFactory objFactory = new us.ny.state.wcb.xml.ns.c4narr_1510.ObjectFactory();

            // Profession (C-4NARR)
            us.ny.state.wcb.xml.ns.c4narr_1510.Data.Doctor.Profession professionPhysician = objFactory.createDataDoctorProfession();
            professionPhysician.setValue(1);
            us.ny.state.wcb.xml.ns.c4narr_1510.Data.Doctor.Profession professionPodiatrist = objFactory.createDataDoctorProfession();
            professionPodiatrist.setValue(2);
            us.ny.state.wcb.xml.ns.c4narr_1510.Data.Doctor.Profession professionChiropractor = objFactory.createDataDoctorProfession();
            professionChiropractor.setValue(3);

            // Instantiate a single Document object (which contains discrete data and one or more attachment objects)
            us.ny.state.wcb.xml.ns.c4narr_1510.Document document = objFactory.createDocument();

            // Attach the document to the submission
            sub.getDocumentOrDocumentOrDocument().add(document);

            // Set the document's attributes

            // REQUIRED - Submitter's document identification code (must be unique within the submission)
            document.setBpDocumentId("DOC00" + (i + 1));

            // OPTIONAL - Document level comment for submitter's use
            document.setBpDocumentComment("Patient: Joe Smith");

            // Start of discrete data for C-4NARR

            // Instantiate the Document's Data object
            us.ny.state.wcb.xml.ns.c4narr_1510.Data data = objFactory.createData();

            // Attach the data object to the document
            document.setData(data);

            // Set the data object's attributes

            // REQUIRED - Fixed value
            data.setFormId("C-4NARR");

            // REQUIRED - Fixed value
            data.setVersionNumber("1510");

            // REQUIRED - Fixed value
            data.setSourceCode("X");

            // REQUIRED - Fixed value
            data.setMaintenanceTypeCode("050");

            // Set the C-4NARR data object's properties

            // Patient

            // Instantiate the Patient object
            us.ny.state.wcb.xml.ns.c4narr_1510.Data.Patient patient = objFactory.createDataPatient();

            // Attach it to the data object
            data.setPatient(patient);

            // Now, set the Patient data

            // REQUIRED - Patient's Last Name
            patient.setLastName("Smith");

            // REQUIRED - Patient's First Name
            patient.setFirstName("Joe");

            // OPTIONAL - Patient's Middle Initial
//            patient.setMiddleInitial("");

            // REQUIRED - Patient's Address Line 1
            patient.setAddr1("123 Fourth St.");

            // OPTIONAL - Patient's Address Line 2
//            patient.setAddr2("");

            // REQUIRED - Patient's City
            patient.setCity("Albany");

            // CONDITIONALLY REQUIRED - Patient's State - Required when country is USA
            patient.setState("NY");

            // CONDITIONALLY REQUIRED - Patient's Zip Code - Required when country is USA or Canada
            patient.setZip("122030001");

            // CONDITIONALLY REQUIRED - Patient's Country - Required if Zip Code is not present.  If country is not set, USA is assumed.
//            patient.setCountry("");

            // OPTIONAL - Patient's Telephone
//            patient.setTelephone("");

            // OPTIONAL - Patient's WCB Case Number
//            patient.setWcbCaseNumber("");

            // OPTIONAL - Carrier's Case Number
//            patient.setCarrierCaseNumber("");

            // REQUIRED - Patient's Gender
            patient.setGender(genderMale);

            // REQUIRED - Patient's Date of Birth
            patient.setDateOfBirth(new Date());

            // OPTIONAL - Patient's Social Security Number
//            patient.setSsn("");

            // REQUIRED - Patient's Date of Injury - Since it allows 00 for Month or Day, it is a string value and,
            //                             therefore, must be formatted properly with the hyphens (YYYY-MM-DD)
            patient.setDateOfInjury("2004-12-01");

            // REQUIRED - Patient's Job Title
            patient.setJobTitle("Construction Worker");

            // REQUIRED - Patient's Work Activities (Be as descriptive as possible)
            patient.setWorkActivities("Framing, plumbing, electrical...");

            // REQUIRED - Patient (currently) Working Flag (use constant flagN or flagY)
            patient.setPatientWorking(flagN);

            // OPTIONAL - Patient's Account Number (Doctor's internal account number for the patient)
//            patient.setPatientAccountNo("");

            // End of Patient Data

            // Employer

            // Instantiate the Employer object
            us.ny.state.wcb.xml.ns.c4narr_1510.Data.Employer employer = objFactory.createDataEmployer();

            // Attach it to the data object
            data.setEmployer(employer);

            // Now, set the Employer data

            // REQUIRED - Employer Name Line 1
            employer.setName1("Jones Construction");

            // OPTIONAL - Employer Name Line 2
//            employer.setName2("");

            // REQUIRED - Employer Address Line 1
            employer.setAddr1("456 Seventh St.");

            // OPTIONAL - Employer Address Line 2
//            employer.setAddr2("");

            // REQUIRED - Employer City
            employer.setCity("Albany");

            // CONDITIONALLY REQUIRED - Employer's State - Required when country is USA
            employer.setState("NY");

            // CONDITIONALLY REQUIRED - Employer's Zip Code - Required when country is USA or Canada
            employer.setZip("122220002");

            // CONDITIONALLY REQUIRED - Employer's Country - Required if Zip Code is not present.  If country is not set, USA is assumed.
//            employer.setCountry("");

            // OPTIONAL - Employer's Telephone
//            employer.setTelephone("");

            // End of Employer Data

            // Doctor

            // Instantiate the Doctor object
            us.ny.state.wcb.xml.ns.c4narr_1510.Data.Doctor doctor = objFactory.createDataDoctor();

            // Attach it to the data object
            data.setDoctor(doctor);

            // Now, set the Doctor data

            // REQUIRED - Doctor's Last Name
            doctor.setLastName("Johnson");

            // REQUIRED - Doctor's First Name
            doctor.setFirstName("Robert");

            // OPTIONAL - Doctor's Middle Initial
//            doctor.setMiddleInitial("");

            // REQUIRED - Doctor's Profession (use constant professionPhysician, professionPodiatrist, or professionChiropractor)
            doctor.setProfession(professionPhysician);

            // CONDITIONALLY REQUIRED - Doctor's WCB Authorization Number
            // Required for WCB authorized doctors
            doctor.setWcbAuthorizationNumber("187912-1W");

            // CONDITIONALLY REQUIRED - At least one of the Doctor's WCB Rating Codes
            // Required for WCB authorized doctors
            doctor.getWcbRatingCode().add("CIM-ONCL"); // Call add() once for each code
            doctor.getWcbRatingCode().add("CIM-RHE");
            doctor.getWcbRatingCode().add("CPA-CC");

            // CONDITIONALLY REQUIRED - Doctor's New York State License Number
            // Required when doctor is New York State-licensed, but not WCB authorized
//            doctor.setNysLicenseNumber("");

            // CONDITIONALLY REQUIRED - Doctors National Provider Identifier (NPI)
            // Required when doctor is licensed outside of New York State
//            doctor.setNpiNumber("");

            // REQUIRED - Doctor's Federal ID Number

            // First, instantiate Federal ID class
            us.ny.state.wcb.xml.ns.c4narr_1510.Data.Doctor.FederalIdNumber federalIdNumber = objFactory.createDataDoctorFederalIdNumber();

            // Next, attach to the doctor
            doctor.setFederalIdNumber(federalIdNumber);

            // Next, set the Federal ID Number value
            federalIdNumber.setValue("123456789");

            // Lastly, set the Federal ID Type (1=SSN, 2=EIN)
            federalIdNumber.setType(1);

            // OPTIONAL - Doctor's Federal ID Number Type (use constant federalIdTypeSSN or federalIdTypeEIN to indicate Federal ID is SSN or EIN, respectively)
//            doctor.setFederalIdType(federalIdTypeSSN);

            // Doctor's Addresses

            // Office Location - Instantiate the Office Location Object
            us.ny.state.wcb.xml.ns.c4narr_1510.Data.Doctor.OfficeLocation officeLocation = objFactory.createDataDoctorOfficeLocation();

            // Attach it to the doctor object
            doctor.setOfficeLocation(officeLocation);

            // Populate Office Location items

            // REQUIRED - Office Location Address Line 1
            officeLocation.setAddr1("123 Fourth St, Suite 102");

            // OPTIONAL - Office Location Address Line 2
//            officeLocation.setAddr2("");

            // REQUIRED - Office Location City
            officeLocation.setCity("Albany");

            // CONDITIONALLY REQUIRED - Office Location State - Required when country is USA
            officeLocation.setState("NY");

            // CONDITIONALLY REQUIRED - Office Location Zip Code - Required when country is USA or Canada
            officeLocation.setZip("12200");

            // CONDITIONALLY REQUIRED - Office Location Country - Required if Zip Code is not present.  If country is not set, USA is assumed.
//            officeLocation.setCountry("");

            // REQUIRED - Office Location Telephone
            officeLocation.setTelephone("5185551212");

            // Billing Address - Instantiate the Billing Address Object
            us.ny.state.wcb.xml.ns.c4narr_1510.Data.Doctor.BillingAddress billingAddress = objFactory.createDataDoctorBillingAddress();

            // Attach it to the doctor object
            doctor.setBillingAddress(billingAddress);

            // Populate Billing Address items

            // OPTIONAL - Billing Address, Name Line 1
//            billingAddress.setName1("");

            // OPTIONAL - Billing Address, Name Line 2
//            billingAddress.setName2("");

            // REQUIRED - Billing Address, Address Line 1
            billingAddress.setAddr1("186 River St");

            // OPTIONAL - Billing Address, Address Line 2
//            billingAddress.setAddr2("");

            // REQUIRED - Billing Address City
            billingAddress.setCity("Troy");

            // CONDITIONALLY REQUIRED - Billing Address State - Required when country is USA
            billingAddress.setState("NY");

            // CONDITIONALLY REQUIRED - Billing Address Zip Code - Required when country is USA or Canada
            billingAddress.setZip("13658");

            // CONDITIONALLY REQUIRED - Billing Address Country - Required if Zip Code is not present.  If country is not set, USA is assumed.
//            billingAddress.setCountry("");

            // OPTIONAL - Billing Address Telephone
//            billingAddress.setTelephone("");

            // End of Doctor Data

            // Billing Information

            // Instantiate the Billing Information object
            us.ny.state.wcb.xml.ns.c4narr_1510.Data.BillingInformation billingInformation = objFactory.createDataBillingInformation();

            // Attach it to the data object
            data.setBillingInformation(billingInformation);

            // Now, populate the Billing Information items

            // Instantiate the Carrier object
            // NOTE:  The Carrier object, as a whole, is OPTIONAL.  If you do not have carrier data, DO NOT create and attach a Carrier object.
            //        Instead, skip to the Diagnosis items farther down.  Once you attach the Carrier object, its items become REQUIRED as identified.
            us.ny.state.wcb.xml.ns.c4narr_1510.Data.BillingInformation.Carrier carrier = objFactory.createDataBillingInformationCarrier();

            // Attach it to the Billing Information object
            billingInformation.setCarrier(carrier);

            // Now, set the Carrier items

            // OPTIONAL - Carrier's WCB Carrier ID ("W" number in the format W000000)
//            carrier.setWcbCarrierId("W000000");

            // REQUIRED - Carrier's Name Line 1
            carrier.setName1("Aetna Insurance");

            // OPTIONAL - Carrier's Name Line 2
//            carrier.setName2("");

            // REQUIRED - Carrier's Address Line 1
            carrier.setAddr1("123 Corporate Blvd");

            // OPTIONAL - Carrier's Address Line 2
//            carrier.setAddr2("");

            // REQUIRED - Carrier's City
            carrier.setCity("New York");

            // CONDITIONALLY REQUIRED - Carrier's State - Required when country is USA
            carrier.setState("NY");

            // CONDITIONALLY REQUIRED - Carrier's Zip Code - Required when country is USA or Canada
            carrier.setZip("10010");

            // CONDITIONALLY REQUIRED - Carrier's Country - Required if Zip Code is not present.  If country is not set, USA is assumed.
//            carrier.setCountry("");

            // Diagnosis

            // Loop thru them...there can be up to 4
            for (int j = 0; j < 1; j++) {
              // One set of static data as an example

              // For each diagnosis, instantiate a diagnosis object
              us.ny.state.wcb.xml.ns.c4narr_1510.Data.BillingInformation.Diagnosis diagnosis = objFactory.createDataBillingInformationDiagnosis();

              // Attach it to the Billing Information object
              billingInformation.getDiagnosis().add(diagnosis);

              // Populate the Diagnosis Items

              // REQUIRED - Diagnosis (ICD9) Code
              diagnosis.setDiagnosisCode("195.4");

              // REQUIRED - Diagnosis (ICD9) Description
              diagnosis.setDiagnosisDesc("Upper limb fracture.");
            }

            // Procedures

            // Loop through them...there is no limit on the number of procedures and there must be at least one.
            for (int j = 0; j < 1; j++) {
              // One set of static data as an example

              // Instantiate a Procedure object
              us.ny.state.wcb.xml.ns.c4narr_1510.Data.BillingInformation.Procedure procedure = objFactory.createDataBillingInformationProcedure();

              // Attach it to the Billing Information object
              billingInformation.getProcedure().add(procedure);

              // Populate the Procedure items

              // REQUIRED - Procedure Service From Date (Start Date)
              procedure.setServiceFromDate(new Date()); // Uses the current date for sample simplicity

              // REQUIRED - Procedure Service Through Date (End Date)
              procedure.setServiceThruDate(new Date()); // Uses the current date for sample simplicity

              // OPTIONAL - Procedure Place of Service
//              procedure.setPlaceOfService("");

              // REQUIRED - Procedure Code
              procedure.setProcedureCode("99123");

              // OPTIONAL - Procedure Modifier A
//              procedure.setProcedureModifierA("");

              // OPTIONAL - Procedure Modifier B
//              procedure.setProcedureModifierB("");

              // REQUIRED - Procedure Service Diagnosis Code
              procedure.setServiceDiagnosisCode("1");

              // REQUIRED - Procedure Service Charge Amount
              procedure.setServiceChargeAmount(new Double(20.79));

              // OPTIONAL - Procedure Service Days or Units
//              procedure.setServiceDaysOrUnits("");

              // OPTIONAL - Procedure Service COB
//              procedure.setServiceCob("");

              // REQUIRED - Procedure Service Zip Code
              procedure.setServiceZipCode("12345");
            }

            // OPTIONAL - Preferred Provider Organization Flag (use constant flagN or flagY)
//            billingInformation.setWcbPpo(flagY);

            // End of Billing Information Data

            // Opinion

            // Instantiate the Opinion object
            us.ny.state.wcb.xml.ns.c4narr_1510.Data.Opinion opinion = objFactory.createDataOpinion();

            // Attach it to the data object
            data.setOpinion(opinion);

            // Now, populate the Opinion items

            // REQUIRED - Competent Producing Cause Flag (use constant flagN or flagY)
            opinion.setCompetentProducingCause(flagY);

            // REQUIRED - History Consistent With Complaint Flag (use constant flagN or flagY)
            opinion.setHistoryConsistentComplaint(flagY);

            // REQUIRED - History Consistent With Findings Flag (use constant flagUnknownN, flagUnknownY, or flagUnknownU)
            opinion.setHistoryConsistentFindings(flagUnknownY);

            // REQUIRED - Percentage of Temporary Impairment
            opinion.setPercentTempImpairment(new Double(20.71));

            // End of Opinion Data

            // Authorized Doctor

            // Instantiate the Authorized Doctor object
            us.ny.state.wcb.xml.ns.c4narr_1510.Data.AuthorizedDoctor authorizedDoctor = objFactory.createDataAuthorizedDoctor();

            // Attach it to the data object
            data.setAuthorizedDoctor(authorizedDoctor);

            // Now, populate the Authorized Doctor items

            // REQUIRED - Authorized Doctor Provided Services Flag (use constant flagN or flagY)
            authorizedDoctor.setProvidedServices(flagN);

            // REQUIRED - Authorized Doctor Last Name
            authorizedDoctor.setLastName("Johnson");

            // REQUIRED - Authorized Doctor First Name
            authorizedDoctor.setFirstName("Robert");

            // OPTIONAL - Authorized Doctor Middle Initial
//            authorizedDoctor.setMiddleInitial("");

            // REQUIRED - Authorized Doctor Specialty
            authorizedDoctor.setSpecialty("Internal Medicine");

            // End of Authorized Doctor Data

            // Supervised Health Care Provider

            // Instantiate the Supervised Health Care Provider object
            // NOTE:  The Supervised Health Care Provider object, as a whole, is CONDITIONALLY REQUIRED.  It is only required when the
            //        Authorized Doctor Provided Services Flag above is set to flagN.  Once you attach the Supervised Health Care Provider object,
            //        its items become REQUIRED as identified.
            us.ny.state.wcb.xml.ns.c4narr_1510.Data.AuthorizedDoctor.SupervisedHealthCareProvider supervisedHealthCareProvider = new us.ny.state.wcb.xml.ns.c4narr_1510.Data.AuthorizedDoctor.SupervisedHealthCareProvider();

            // Attach it to the data object
            data.getAuthorizedDoctor().setSupervisedHealthCareProvider(supervisedHealthCareProvider);

            // REQUIRED - Supervised Health Care Provider Last Name
            supervisedHealthCareProvider.setLastName("Chang");

            // REQUIRED - Supervised Health Care Provider First Name
            supervisedHealthCareProvider.setFirstName("Paul");

            // OPTIONAL - Supervised Health Care Provider Middle Initial
//            supervisedHealthCareProvider.setMiddleInitial("");

            // REQUIRED - Supervised Health Care Provider Specialty
            supervisedHealthCareProvider.setSpecialty("Neurology");

            // End of Supervised Health Care Provider Data

            // End of discrete data for C-4NARR

            // The C-4NARR *requires* at least one attachment which goes into detail regarding injury, treatment, current status, etc.
            // This one required attachment can be text or binary.  It does not matter which.
            // For sample purposes, we will generate one of each to demonstrate both.
            // There is no limit on the number of attachments allowed.  The order of attachments will be preserved when they are imported
            // into WCB's data system.

            // Start of Attachments

            // Add one binary attachment

            // Instantiate the binary attachment object
            AttachmentBinary bin = wcbObjFactory.createAttachmentBinary();

            // Add the binary attachment to the current document
            document.getAttachmentTextOrAttachmentBinary().add(bin);

            // Set the binary attachment's attributes

            // REQUIRED - Binary Attachment's MIME Type - Fixed value - only "image/tiff" is currently allowed.
            bin.setContentType("image/tiff");

            // REQUIRED - Binary Attachment's Reference - This is be the name of the file, included with the submission, that contains the actual
            //            binary attachment.
            bin.setRef("im00001.tif"); // The file named 'im00001.tif' would have to be included with the submission

            // Add one text attachment

            // Instantiate the text attachment object
            // A text attachment consists of one or more pages of 56 lines with 100 characters each.  WCB will internally convert each page to an
            // image by printing the lines of text with a fixed space Courier font, so spaces may be used for formatting and this formatting will
            // be preserved.  Blank lines are also allowed.
            AttachmentText txt = wcbObjFactory.createAttachmentText();

            // Add the text attachment to the current document
            document.getAttachmentTextOrAttachmentBinary().add(txt);

            // For sample purposes, create two pages of text

            // Instantiate a page object for page 1 (at least one page is required)
            AttachmentText.Page pg = wcbObjFactory.createAttachmentTextPage();

            // Add page 1 to the text attachment
            txt.getPage().add(pg);

            // Now, add lines of text to page 1 (max of 56 lines per page, max of 100 characters per line)
            // There must be at least one line on each page.
            pg.getLine().add("Patient:");
            pg.getLine().add("Joe Smith");
            pg.getLine().add("123 Fourth St");
            pg.getLine().add("Albany, NY 12241");
            pg.getLine().add(""); // Blank lines allowed to preserve formatting
            pg.getLine().add("The patient fell at work and broke his arm.  It appears to be healing well.");
            pg.getLine().add("I recommend 8 more weeks be allowed for recovery.  100% recovery is expected.");
            pg.getLine().add("And so on and so forth... (the explanation should be as detailed as possible)");

            // Instantiate a page object for page 2 (we can reuse variable 'pg' since we're done with it)
            pg = wcbObjFactory.createAttachmentTextPage();

            // Add page 2 to the text attachment
            txt.getPage().add(pg);

            // Now, add lines of text to page 2 (max of 56 lines per page, max of 100 characters per line)
            // There must be at least one line on each page.
            pg.getLine().add("This is the second page of the text attachment.");
            pg.getLine().add("<>\"'&");

            // Add unlimited additional pages as required...

            // End of Attachments

            // Population of one C-4NARR document is complete
            break;
          }

          case 2: {
            // C-4AMR

            // Object Factory (C-4AMR)
            us.ny.state.wcb.xml.ns.c4amr_1510.ObjectFactory objFactory = new us.ny.state.wcb.xml.ns.c4amr_1510.ObjectFactory();

            // Profession (C-4AMR)
            us.ny.state.wcb.xml.ns.c4amr_1510.Data.Doctor.Profession professionPhysician = objFactory.createDataDoctorProfession();
            professionPhysician.setValue(1);
            us.ny.state.wcb.xml.ns.c4amr_1510.Data.Doctor.Profession professionPodiatrist = objFactory.createDataDoctorProfession();
            professionPodiatrist.setValue(2);
            us.ny.state.wcb.xml.ns.c4amr_1510.Data.Doctor.Profession professionChiropractor = objFactory.createDataDoctorProfession();
            professionChiropractor.setValue(3);

            // Instantiate a single Document object (which contains discrete data and one or more attachment objects)
            us.ny.state.wcb.xml.ns.c4amr_1510.Document document = objFactory.createDocument();

            // Attach the document to the submission
            sub.getDocumentOrDocumentOrDocument().add(document);

            // Set the document's attributes

            // REQUIRED - Submitter's document identification code (must be unique within the submission)
            document.setBpDocumentId("DOC00" + (i + 1));

            // OPTIONAL - Document level comment for submitter's use
            document.setBpDocumentComment("Patient: Joe Smith");

            // Start of discrete data for C-4AMR

            // Instantiate the Document's Data object
            us.ny.state.wcb.xml.ns.c4amr_1510.Data data = objFactory.createData();

            // Attach the data object to the document
            document.setData(data);

            // Set the data object's attributes

            // REQUIRED - Fixed value
            data.setFormId("C-4AMR");

            // REQUIRED - Fixed value
            data.setVersionNumber("1510");

            // REQUIRED - Fixed value
            data.setSourceCode("X");

            // REQUIRED - Fixed value
            data.setMaintenanceTypeCode("050");

            // Set the C-4AMR data object's properties

            // Patient

            // Instantiate the Patient object
            us.ny.state.wcb.xml.ns.c4amr_1510.Data.Patient patient = objFactory.createDataPatient();

            // Attach it to the data object
            data.setPatient(patient);

            // Now, set the Patient data

            // REQUIRED - Patient's Last Name
            patient.setLastName("Smith");

            // REQUIRED - Patient's First Name
            patient.setFirstName("Joe");

            // OPTIONAL - Patient's Middle Initial
//            patient.setMiddleInitial("");

            // REQUIRED - Patient's Address Line 1
            patient.setAddr1("123 Fourth St.");

            // OPTIONAL - Patient's Address Line 2
//            patient.setAddr2("");

            // REQUIRED - Patient's City
            patient.setCity("Albany");

            // CONDITIONALLY REQUIRED - Patient's State - Required when country is USA
            patient.setState("NY");

            // CONDITIONALLY REQUIRED - Patient's Zip Code - Required when country is USA or Canada
            patient.setZip("122030001");

            // CONDITIONALLY REQUIRED - Patient's Country - Required if Zip Code is not present.  If country is not set, USA is assumed.
//            patient.setCountry("");

            // OPTIONAL - Patient's Telephone
//            patient.setTelephone("");

            // OPTIONAL - Patient's WCB Case Number
//            patient.setWcbCaseNumber("");

            // OPTIONAL - Carrier's Case Number
//            patient.setCarrierCaseNumber("");

            // REQUIRED - Patient's Date of Birth
            patient.setDateOfBirth(new Date());

            // OPTIONAL - Patient's Social Security Number
//            patient.setSsn("");

            // REQUIRED - Patient's Date of Injury - Since it allows 00 for Month or Day, it is a string value and,
            //                             therefore, must be formatted properly with the hyphens (YYYY-MM-DD)
            patient.setDateOfInjury("2004-12-01");

            // OPTIONAL - Patient's Account Number (Doctor's internal account number for the patient)
//            patient.setPatientAccountNo("");

            // End of Patient Data

            // Doctor

            // Instantiate the Doctor object
            us.ny.state.wcb.xml.ns.c4amr_1510.Data.Doctor doctor = objFactory.createDataDoctor();

            // Attach it to the data object
            data.setDoctor(doctor);

            // Now, set the Doctor data

            // REQUIRED - Doctor's Last Name
            doctor.setLastName("Johnson");

            // REQUIRED - Doctor's First Name
            doctor.setFirstName("Robert");

            // OPTIONAL - Doctor's Middle Initial
//            doctor.setMiddleInitial("");

            // REQUIRED - Doctor's Profession (use constant professionPhysician, professionPodiatrist, or professionChiropractor)
            doctor.setProfession(professionPhysician);

            // CONDITIONALLY REQUIRED - Doctor's WCB Authorization Number
            // Required for WCB authorized doctors
            doctor.setWcbAuthorizationNumber("187912-1W");

            // CONDITIONALLY REQUIRED - At least one of the Doctor's WCB Rating Codes
            // Required for WCB authorized doctors
            doctor.getWcbRatingCode().add("CIM-ONCL"); // Call add() once for each code
            doctor.getWcbRatingCode().add("CIM-RHE");
            doctor.getWcbRatingCode().add("CPA-CC");

            // CONDITIONALLY REQUIRED - Doctor's New York State License Number
            // Required when doctor is New York State-licensed, but not WCB authorized
//            doctor.setNysLicenseNumber("");

            // CONDITIONALLY REQUIRED - Doctor's National Provider Identifier (NPI)
            // Required when doctor is licensed outside of New York State
//            doctor.setNpiNumber("");

            // REQUIRED - Doctor's Federal ID Number

            // First, instantiate Federal ID class
            us.ny.state.wcb.xml.ns.c4amr_1510.Data.Doctor.FederalIdNumber federalIdNumber = objFactory.createDataDoctorFederalIdNumber();

            // Next, attach to the doctor
            doctor.setFederalIdNumber(federalIdNumber);

            // Next, set the Federal ID Number value
            federalIdNumber.setValue("123456789");

            // Lastly, set the Federal ID Type (1=SSN, 2=EIN)
            federalIdNumber.setType(1);

            // Doctor's Addresses

            // Office Location - Instantiate the Office Location Object
            us.ny.state.wcb.xml.ns.c4amr_1510.Data.Doctor.OfficeLocation officeLocation = objFactory.createDataDoctorOfficeLocation();

            // Attach it to the doctor object
            doctor.setOfficeLocation(officeLocation);

            // Populate Office Location items

            // REQUIRED - Office Location Address Line 1
            officeLocation.setAddr1("123 Fourth St, Suite 102");

            // OPTIONAL - Office Location Address Line 2
//            officeLocation.setAddr2("");

            // REQUIRED - Office Location City
            officeLocation.setCity("Albany");

            // CONDITIONALLY REQUIRED - Office Location State - Required when country is USA
            officeLocation.setState("NY");

            // CONDITIONALLY REQUIRED - Office Location Zip Code - Required when country is USA or Canada
            officeLocation.setZip("12200");

            // CONDITIONALLY REQUIRED - Office Location Country - Required if Zip Code is not present.  If country is not set, USA is assumed.
//            officeLocation.setCountry("");

            // REQUIRED - Office Location Telephone
            officeLocation.setTelephone("5185551212");

            // Billing Address - Instantiate the Billing Address Object
            us.ny.state.wcb.xml.ns.c4amr_1510.Data.Doctor.BillingAddress billingAddress = objFactory.createDataDoctorBillingAddress();

            // Attach it to the doctor object
            doctor.setBillingAddress(billingAddress);

            // Populate Billing Address items

            // OPTIONAL - Billing Address, Name Line 1
//            billingAddress.setName1("");

            // OPTIONAL - Billing Address, Name Line 2
//            billingAddress.setName2("");

            // REQUIRED - Billing Address, Address Line 1
            billingAddress.setAddr1("186 River St");

            // OPTIONAL - Billing Address, Address Line 2
//            billingAddress.setAddr2("");

            // REQUIRED - Billing Address City
            billingAddress.setCity("Troy");

            // CONDITIONALLY REQUIRED - Billing Address State - Required when country is USA
            billingAddress.setState("NY");

            // CONDITIONALLY REQUIRED - Billing Address Zip Code - Required when country is USA or Canada
            billingAddress.setZip("13658");

            // CONDITIONALLY REQUIRED - Billing Address Country - Required if Zip Code is not present.  If country is not set, USA is assumed.
//            billingAddress.setCountry("");

            // OPTIONAL - Billing Address Telephone
//            billingAddress.setTelephone("xxx");

            // Referring Doctor - Instantiate the Referring Doctor Object
            us.ny.state.wcb.xml.ns.c4amr_1510.Data.Doctor.ReferringDoctor referringDoctor = objFactory.createDataDoctorReferringDoctor();

            // Attach it to the doctor object
            doctor.setReferringDoctor(referringDoctor);

            // REQUIRED - Referring Doctor Last Name
            referringDoctor.setLastName("Ferrer");

            // REQUIRED - Referring Doctor First Name
            referringDoctor.setFirstName("Robert");

            // OPTIONAL - Referring Doctor Middle Initial
//            referringDoctor.setMiddleInitial("");

            // End of Doctor Data

            // Billing Information

            // Instantiate the Billing Information object
            us.ny.state.wcb.xml.ns.c4amr_1510.Data.BillingInformation billingInformation = objFactory.createDataBillingInformation();

            // Attach it to the data object
            data.setBillingInformation(billingInformation);

            // Now, populate the Billing Information items

            // Instantiate the Carrier object
            // NOTE:  The Carrier object, as a whole, is OPTIONAL.  If you do not have carrier data, DO NOT create and attach a Carrier object.
            //        Instead, skip to the Diagnosis items farther down.  Once you attach the Carrier object, its items become REQUIRED as identified.
            us.ny.state.wcb.xml.ns.c4amr_1510.Data.BillingInformation.Carrier carrier = objFactory.createDataBillingInformationCarrier();

            // Attach it to the Billing Information object
            billingInformation.setCarrier(carrier);

            // Now, set the Carrier items

            // OPTIONAL - Carrier's WCB Carrier ID ("W" number in the format W000000)
//            carrier.setWcbCarrierId("W000000");

            // REQUIRED - Carrier's Name Line 1
            carrier.setName1("Aetna Insurance");

            // OPTIONAL - Carrier's Name Line 2
//            carrier.setName2("");

            // REQUIRED - Carrier's Address Line 1
            carrier.setAddr1("123 Corporate Blvd");

            // OPTIONAL - Carrier's Address Line 2
//            carrier.setAddr2("");

            // REQUIRED - Carrier's City
            carrier.setCity("New York");

            // CONDITIONALLY REQUIRED - Carrier's State - Required when country is USA
            carrier.setState("NY");

            // CONDITIONALLY REQUIRED - Carrier's Zip Code - Required when country is USA or Canada
            carrier.setZip("10010");

            // CONDITIONALLY REQUIRED - Carrier's Country - Required if Zip Code is not present.  If country is not set, USA is assumed.
//            carrier.setCountry("");

            // Diagnosis

            // Loop thru them...there can be up to 4
            for (int j = 0; j < 1; j++) {
              // One set of static data as an example

              // For each diagnosis, instantiate a diagnosis object
              us.ny.state.wcb.xml.ns.c4amr_1510.Data.BillingInformation.Diagnosis diagnosis = objFactory.createDataBillingInformationDiagnosis();

              // Attach it to the Billing Information object
              billingInformation.getDiagnosis().add(diagnosis);

              // Populate the Diagnosis Items

              // REQUIRED - Diagnosis (ICD9) Code
              diagnosis.setDiagnosisCode("195.4");

              // REQUIRED - Diagnosis (ICD9) Description
              diagnosis.setDiagnosisDesc("Upper limb fracture.");
            }

            // Procedures

            // Loop through them...there is no limit on the number of procedures and there must be at least one.
            for (int j = 0; j < 1; j++) {
              // One set of static data as an example

              // Instantiate a Procedure object
              us.ny.state.wcb.xml.ns.c4amr_1510.Data.BillingInformation.Procedure procedure = objFactory.createDataBillingInformationProcedure();

              // Attach it to the Billing Information object
              billingInformation.getProcedure().add(procedure);

              // Populate the Procedure items

              // REQUIRED - Procedure Service From Date (Start Date)
              procedure.setServiceFromDate(new Date()); // Uses the current date for sample simplicity

              // REQUIRED - Procedure Service Through Date (End Date)
              procedure.setServiceThruDate(new Date()); // Uses the current date for sample simplicity

              // OPTIONAL - Procedure Place of Service
//              procedure.setPlaceOfService("");

              // REQUIRED - Procedure Code
              procedure.setProcedureCode("99213");

              // OPTIONAL - Procedure Modifier A
//              procedure.setProcedureModifierA("");

              // OPTIONAL - Procedure Modifier B
//              procedure.setProcedureModifierB("");

              // REQUIRED - Procedure Service Diagnosis Code
              procedure.setServiceDiagnosisCode("1");

              // REQUIRED - Procedure Service Charge Amount
              procedure.setServiceChargeAmount(new Double(20.79));

              // OPTIONAL - Procedure Service Days or Units
//              procedure.setServiceDaysOrUnits("");

              // OPTIONAL - Procedure Service COB
//              procedure.setServiceCob("");

              // REQUIRED - Procedure Service Zip Code
              procedure.setServiceZipCode("12345");
            }

            // OPTIONAL - Preferred Provider Organization Flag (use constant flagN or flagY)
//            billingInformation.setWcbPpo(flagY);

            // End of Billing Information Data

            // Authorized Doctor

            // Instantiate the Authorized Doctor object
            us.ny.state.wcb.xml.ns.c4amr_1510.Data.AuthorizedDoctor authorizedDoctor = objFactory.createDataAuthorizedDoctor();

            // Attach it to the data object
            data.setAuthorizedDoctor(authorizedDoctor);

            // Now, populate the Authorized Doctor items

            // REQUIRED - Authorized Doctor Last Name
            authorizedDoctor.setLastName("Johnson");

            // REQUIRED - Authorized Doctor First Name
            authorizedDoctor.setFirstName("Robert");

            // OPTIONAL - Authorized Doctor Middle Initial
//            authorizedDoctor.setMiddleInitial("");

            // REQUIRED - Authorized Doctor Specialty
            authorizedDoctor.setSpecialty("Internal Medicine");

            // REQUIRED - Authorized Doctor Provided Services Flag (use constant flagN or flagY)
            authorizedDoctor.setProvidedServices(flagN);

            // Supervised Health Care Provider

            // Instantiate the Supervised Health Care Provider object
            // NOTE:  The Supervised Health Care Provider object, as a whole, is CONDITIONALLY REQUIRED.  It is only required when the
            //        Authorized Doctor Provided Services Flag above is set to flagN.  Once you attach the Supervised Health Care Provider object,
            //        its items become REQUIRED as identified.
            us.ny.state.wcb.xml.ns.c4amr_1510.Data.AuthorizedDoctor.SupervisedHealthCareProvider supervisedHealthCareProvider = objFactory.createDataAuthorizedDoctorSupervisedHealthCareProvider();

            // Attach it to the authorized doctor object
            data.getAuthorizedDoctor().setSupervisedHealthCareProvider(supervisedHealthCareProvider);

            // REQUIRED - Supervised Health Care Provider Last Name
            supervisedHealthCareProvider.setLastName("Chang");

            // REQUIRED - Supervised Health Care Provider First Name
            supervisedHealthCareProvider.setFirstName("Paul");

            // OPTIONAL - Supervised Health Care Provider Middle Initial
//            supervisedHealthCareProvider.setMiddleInitial("");

            // REQUIRED - Supervised Health Care Provider Specialty
            supervisedHealthCareProvider.setSpecialty("Neurology");

            // End of Supervised Health Care Provider Data

            // End of Authorized Doctor Data

            // End of discrete data for C-4AMR

            // The C-4AMR does not require any attachments.  Attachments can be text or binary.
            // For sample purposes, we will generate one of each to demonstrate both.
            // There is no limit on the number of attachments allowed.  The order of attachments will be preserved when they are imported
            // into WCB's data system.

            // Start of Attachments

            // Add one binary attachment

            // Instantiate the binary attachment object
            AttachmentBinary bin = wcbObjFactory.createAttachmentBinary();

            // Add the binary attachment to the current document
            document.getAttachmentTextOrAttachmentBinary().add(bin);

            // Set the binary attachment's attributes

            // REQUIRED - Binary Attachment's MIME Type - Fixed value - only "image/tiff" is currently allowed.
            bin.setContentType("image/tiff");

            // REQUIRED - Binary Attachment's Reference - This is be the name of the file, included with the submission, that contains the actual
            //            binary attachment.
            bin.setRef("im00002.tif"); // The file named 'im00002.tif' would have to be included with the submission

            // Add one text attachment

            // Instantiate the text attachment object
            // A text attachment consists of one or more pages of 56 lines with 100 characters each.  WCB will internally convert each page to an
            // image by printing the lines of text with a fixed space Courier font, so spaces may be used for formatting and this formatting will
            // be preserved.  Blank lines are also allowed.
            AttachmentText txt = wcbObjFactory.createAttachmentText();

            // Add the text attachment to the current document
            document.getAttachmentTextOrAttachmentBinary().add(txt);

            // For sample purposes, create two pages of text

            // Instantiate a page object for page 1 (at least one page is required)
            AttachmentText.Page pg = wcbObjFactory.createAttachmentTextPage();

            // Add page 1 to the text attachment
            txt.getPage().add(pg);

            // Now, add lines of text to page 1 (max of 56 lines per page, max of 100 characters per line)
            // There must be at least one line on each page.
            pg.getLine().add("Patient:");
            pg.getLine().add("Robert Smith");
            pg.getLine().add("4 321st St");
            pg.getLine().add("Albany, NY 12202");
            pg.getLine().add(""); // Blank lines allowed to preserve formatting
            pg.getLine().add("The patient fell at work and broke his arm.  It appears to be healing well.");
            pg.getLine().add("I recommend 8 more weeks be allowed for recovery.  100% recovery is expected.");
            pg.getLine().add("And so on and so forth... (the explanation should be as detailed as possible)");

            // Instantiate a page object for page 2 (we can reuse variable 'pg' since we're done with it)
            pg = wcbObjFactory.createAttachmentTextPage();

            // Add page 2 to the text attachment
            txt.getPage().add(pg);

            // Now, add lines of text to page 2 (max of 56 lines per page, max of 100 characters per line)
            // There must be at least one line on each page.
            pg.getLine().add("This is the second page of the text attachment.");
            pg.getLine().add("<>\"'&");

            // Add unlimited additional pages as required...

            // End of Attachments

            // Population of one C-4AMR document is complete
            break;
          }

          case 3: {
            // OT/PT-4

            // Object Factory (OT/PT-4)
            us.ny.state.wcb.xml.ns.otpt4_1510.ObjectFactory objFactory = new us.ny.state.wcb.xml.ns.otpt4_1510.ObjectFactory();

            // Profession (OT/PT-4)
            us.ny.state.wcb.xml.ns.otpt4_1510.Data.Therapist.Profession professionOccupationTherapist = objFactory.createDataTherapistProfession();
            professionOccupationTherapist.setValue(1);
            us.ny.state.wcb.xml.ns.otpt4_1510.Data.Therapist.Profession professionPhysicalTherapist = objFactory.createDataTherapistProfession();
            professionPhysicalTherapist.setValue(2);

            // Report Type
            us.ny.state.wcb.xml.ns.otpt4_1510.Data.ReportType reportType48Hour = new us.ny.state.wcb.xml.ns.otpt4_1510.Data.ReportType();
            reportType48Hour.setValue(1);
            us.ny.state.wcb.xml.ns.otpt4_1510.Data.ReportType reportType15Day = new us.ny.state.wcb.xml.ns.otpt4_1510.Data.ReportType();
            reportType15Day.setValue(2);
            us.ny.state.wcb.xml.ns.otpt4_1510.Data.ReportType reportType45Day = new us.ny.state.wcb.xml.ns.otpt4_1510.Data.ReportType();
            reportType45Day.setValue(3);

            // Liable Party
            us.ny.state.wcb.xml.ns.otpt4_1510.Data.LiableParty liablePartyVFBL = new us.ny.state.wcb.xml.ns.otpt4_1510.Data.LiableParty();
            liablePartyVFBL.setValue(1);
            us.ny.state.wcb.xml.ns.otpt4_1510.Data.LiableParty liablePartyVAWBL = new us.ny.state.wcb.xml.ns.otpt4_1510.Data.LiableParty();
            liablePartyVAWBL.setValue(2);

            // Referral Reason
            us.ny.state.wcb.xml.ns.otpt4_1510.Data.EvaluationTreatment.ReferralReason referralReasonEvaluationOnly = new us.ny.state.wcb.xml.ns.otpt4_1510.Data.EvaluationTreatment.ReferralReason();
            referralReasonEvaluationOnly.setValue(1);
            us.ny.state.wcb.xml.ns.otpt4_1510.Data.EvaluationTreatment.ReferralReason referralReasonTreatmentOnly = new us.ny.state.wcb.xml.ns.otpt4_1510.Data.EvaluationTreatment.ReferralReason();
            referralReasonTreatmentOnly.setValue(2);
            us.ny.state.wcb.xml.ns.otpt4_1510.Data.EvaluationTreatment.ReferralReason referralReasonEvaluationAndTreatment = new us.ny.state.wcb.xml.ns.otpt4_1510.Data.EvaluationTreatment.ReferralReason();
            referralReasonEvaluationAndTreatment.setValue(3);

            // Instantiate a single Document object (which contains discrete data and one or more attachment objects)
            us.ny.state.wcb.xml.ns.otpt4_1510.Document document = objFactory.createDocument();

            // Attach the document to the submission
            sub.getDocumentOrDocumentOrDocument().add(document);

            // Set the document's attributes

            // REQUIRED - Submitter's document identification code (must be unique within the submission)
            document.setBpDocumentId("DOC00" + (i + 1));

            // OPTIONAL - Document level comment for submitter's use
            document.setBpDocumentComment("Patient: Joe Smith");

            // Start of discrete data for OT/PT-4

            // Instantiate the Document's Data object
            us.ny.state.wcb.xml.ns.otpt4_1510.Data data = objFactory.createData();

            // Attach the data object to the document
            document.setData(data);

            // Set the data object's attributes

            // REQUIRED - Fixed value
            data.setFormId("OT/PT-4");

            // REQUIRED - Fixed value
            data.setVersionNumber("1510");

            // REQUIRED - Fixed value
            data.setSourceCode("X");

            // REQUIRED - Fixed value
            data.setMaintenanceTypeCode("050");

            // Set the OT/PT-4 data object's properties

            // REQUIRED - Report Type (use constant reportType48Hour, reportType15Day or reportType45Day)
            data.setReportType(reportType48Hour);

            // OPTIONAL - Liable Party (use constant liablePartyVAWBL or liablePartyVFBL)
//            data.setLiableParty(liablePartyVFBL);

            // Claimant

            // Instantiate the Claimant object
            us.ny.state.wcb.xml.ns.otpt4_1510.Data.Claimant claimant = objFactory.createDataClaimant();

            // Attach it to the data object
            data.setClaimant(claimant);

            // Now, set the Claimant data

            // REQUIRED - Claimant's Last Name
            claimant.setLastName("Smith");

            // REQUIRED - Claimant's First Name
            claimant.setFirstName("Joe");

            // OPTIONAL - Claimant's Middle Initial
//            claimant.setMiddleInitial("");

            // REQUIRED - Claimant's Address Line 1
            claimant.setAddr1("123 Fourth St.");

            // OPTIONAL - Claimant's Address Line 2
//            claimant.setAddr2("");

            // REQUIRED - Claimant's City
            claimant.setCity("Albany");

            // CONDITIONALLY REQUIRED - Claimant's State - Required when country is USA
            claimant.setState("NY");

            // CONDITIONALLY REQUIRED - Claimant's Zip Code - Required when country is USA or Canada
            claimant.setZip("122030001");

            // CONDITIONALLY REQUIRED - Claimant's Country - Required if Zip Code is not present.  If country is not set, USA is assumed.
//            claimant.setCountry("");

            // OPTIONAL - Claimant's Telephone
//            claimant.setTelephone("");

            // OPTIONAL - Claimant's Social Security Number
//            claimant.setSsn("");

            // REQUIRED - Claimant's Date of Birth
            claimant.setDateOfBirth(new Date());

            // OPTIONAL - Claimant's WCB Case Number
//            claimant.setWcbCaseNumber("");

            // OPTIONAL - Carrier's Case Number
//            claimant.setCarrierCaseNumber("");

            // REQUIRED - Claimant's Date of Injury - Since it allows 00 for Month or Day, it is a string value and,
            //                             therefore, must be formatted properly with the hyphens (YYYY-MM-DD)
            claimant.setDateOfInjury("2004-12-01");

            // OPTIONAL - Claimant's Time of Injury
            claimant.setTimeOfInjury(javax.xml.datatype.DatatypeFactory.newInstance().newXMLGregorianCalendarTime(13,25,0,javax.xml.datatype.DatatypeConstants.FIELD_UNDEFINED));

            // OPTIONAL - Claimant's Injury Location
//            claimant.setInjuryLocation("");

            // End of Claimant Data

            // Employer

            // Instantiate the Employer object
            us.ny.state.wcb.xml.ns.otpt4_1510.Data.Employer employer = objFactory.createDataEmployer();

            // Attach it to the data object
            data.setEmployer(employer);

            // Now, set the Employer data

            // REQUIRED - Employer Name Line 1
            employer.setName1("Jones Construction");

            // OPTIONAL - Employer Name Line 2
//            employer.setName2("");

            // REQUIRED - Employer Address Line 1
            employer.setAddr1("456 Seventh St.");

            // OPTIONAL - Employer Address Line 2
//            employer.setAddr2("");

            // REQUIRED - Employer City
            employer.setCity("Albany");

            // CONDITIONALLY REQUIRED - Employer's State - Required when country is USA
            employer.setState("NY");

            // CONDITIONALLY REQUIRED - Employer's Zip Code - Required when country is USA or Canada
            employer.setZip("122220002");

            // CONDITIONALLY REQUIRED - Employer's Country - Required if Zip Code is not present.  If country is not set, USA is assumed.
//            employer.setCountry("");

            // End of Employer Data

            // Carrier

            // Instantiate the Carrier object
            // NOTE:  The Carrier object, as a whole, is OPTIONAL.  If you do not have carrier data, DO NOT create and attach a Carrier object.
            //        Instead, skip to the Referrring Doctor items farther down.  Once you attach the Carrier object, its items become REQUIRED as identified.
            us.ny.state.wcb.xml.ns.otpt4_1510.Data.Carrier carrier = objFactory.createDataCarrier();

            // Attach it to the data object
            data.setCarrier(carrier);

            // Now, set the Carrier items

            // REQUIRED - Carrier's Name Line 1
            carrier.setName1("Aetna Insurance");

            // OPTIONAL - Carrier's Name Line 2
//            carrier.setName2("");

            // REQUIRED - Carrier's Address Line 1
            carrier.setAddr1("123 Corporate Blvd");

            // OPTIONAL - Carrier's Address Line 2
//            carrier.setAddr2("");

            // REQUIRED - Carrier's City
            carrier.setCity("New York");

            // CONDITIONALLY REQUIRED - Carrier's State - Required when country is USA
            carrier.setState("NY");

            // CONDITIONALLY REQUIRED - Carrier's Zip Code - Required when country is USA or Canada
            carrier.setZip("10010");

            // CONDITIONALLY REQUIRED - Carrier's Country - Required if Zip Code is not present.  If country is not set, USA is assumed.
//            carrier.setCountry("");

            // End of Carrier Data

            // Referring Doctor

            // Instantiate the Referring Doctor object
            us.ny.state.wcb.xml.ns.otpt4_1510.Data.ReferringDoctor referringDoctor = objFactory.createDataReferringDoctor();

            // Attach it to the data object
            data.setReferringDoctor(referringDoctor);

            // Now, set the Referring Doctor data

            // REQUIRED - Referring Doctor's Last Name
            referringDoctor.setLastName("Johnson");

            // REQUIRED - Referring Doctor's First Name
            referringDoctor.setFirstName("Robert");

            // OPTIONAL - Referring Doctor's Middle Initial
//            referringDoctor.setMiddleInitial("");

            // REQUIRED - Referring Doctor's Address Line 1
            referringDoctor.setAddr1("123 Fourth St, Suite 102");

            // OPTIONAL - Referring Doctor's Address Line 2
//            referringDoctor.setAddr2("");

            // REQUIRED - Referring Doctor's City
            referringDoctor.setCity("Albany");

            // CONDITIONALLY REQUIRED - Referring Doctor's State - Required when country is USA
            referringDoctor.setState("NY");

            // CONDITIONALLY REQUIRED - Referring Doctor's Code - Required when country is USA or Canada
            referringDoctor.setZip("12200");

            // CONDITIONALLY REQUIRED - Referring Doctor's Country - Required if Zip Code is not present.  If country is not set, USA is assumed.
//            referringDoctor.setCountry("");

            // OPTIONAL - Referring Doctor's  Telephone
//            referringDoctor.setTelephone("5185551212");

            // End of Referring Doctor Data

            // History

            // Instantiate the History object
            us.ny.state.wcb.xml.ns.otpt4_1510.Data.History history = objFactory.createDataHistory();

            // Attach it to the data object
            data.setHistory(history);

            // CONDITIONALLY REQUIRED - Previous Report Date - Either Previous Report Date and Referring Doctor's Diagnosis must be present
            Calendar calPrevReportDate = GregorianCalendar.getInstance();
            calPrevReportDate.set(2010, 2, 2); // March 2, 2010 (month is zero-based)
            history.setPreviousReportDate(calPrevReportDate.getTime());

            // CONDITIONALLY REQUIRED - Referring Doctor's Diagnosis - Either Previous Report Date and Referring Doctor's Diagnosis must be present
//            history.setReferringDoctorDiagnosis("");

            // OPTIONAL - History of Pre-existing Injury
//            history.setHistoryOfPreexistingInjury("");

            // End of History Data

            // Evaluation/Treatment

            // Instantiate the Evaluation/Treatment object
            us.ny.state.wcb.xml.ns.otpt4_1510.Data.EvaluationTreatment evaluationTreatment = objFactory.createDataEvaluationTreatment();

            // Attach it to the data object
            data.setEvaluationTreatment(evaluationTreatment);

            // REQUIRED - Referral Reason
            evaluationTreatment.setReferralReason(referralReasonEvaluationOnly);

            // CONDITIONALLY REQUIRED - Evaluation - Required if referral-reason value attribute = 1 (Evaluation Only) or 3 (Evaluation and Treatment)
            evaluationTreatment.setEvaluation("Here is the evaluation...");

            // CONDITIONALLY REQUIRED - Patient's Condition and Progress - Required if referral-reason value attribute = 2 (Treatment Only) or 3 (Evaluation and Treatment)
//            evaluationTreatment.setConditionProgress("");

            // OPTIONAL - Authorization Required (use constant flagN or flagY) - If value = 'Y', then there must be at least one binary attachment (the authorization)
//            evaluationTreatment.setAuthorizationRequired(flagN);

            // CONDITIONALLY REQUIRED - Treatment - Required if referral-reason value attribute = 2 (Treatment Only) or 3 (Evaluation and Treatment)
//            evaluationTreatment.setTreatment("");

            // CONDITIONALLY REQUIRED - Referring Doctor Treatment Plan (use constant flagN or flagY) - Required if referral-reason value attribute = 2 (Treatment Only) or 3 (Evaluation and Treatment)
//            evaluationTreatment.setReferringDoctorTreatmentPlan(flagY);

            // CONDITIONALLY REQUIRED - Treatment Frequency - Required if referring-doctor-treatment-plan value attribute = 'Y'
//            evaluationTreatment.setTreatmentFrequency("");

            // CONDITIONALLY REQUIRED - Treatment Period - Required if referring-doctor-treatment-plan value attribute = 'Y'
//            evaluationTreatment.setTreatmentPeriod("");

            // REQUIRED - Visits From Date
            Calendar calVisitsFromDate = GregorianCalendar.getInstance();
            calVisitsFromDate.set(2010, 3, 4); // April 4, 2010 (month is zero-based)
            evaluationTreatment.setVisitsFromDate(calVisitsFromDate.getTime());

            // REQUIRED - Visits Thru Date
            Calendar calVisitsThruDate = GregorianCalendar.getInstance();
            calVisitsThruDate.set(2010, 3, 5); // April 5, 2010 (month is zero-based)
            evaluationTreatment.setVisitsThruDate(calVisitsThruDate.getTime());

            // REQUIRED - First Visit Date
            Calendar calFirstVisitDate = GregorianCalendar.getInstance();
            calFirstVisitDate.set(2010, 2, 2); // March 2, 2010 (month is zero-based)
            evaluationTreatment.setFirstVisitDate(calFirstVisitDate.getTime());

            // OPTIONAL - Patient Returning Flag (use constant flagN or flagY)
//            evaluationTreatment.setPatientReturning(flagY);

            // CONDITIONALLY REQUIRED - Patient Return Date - Required if patient-returning value attribute = 'Y'
//            GregorianCalendar calPatientReturnDate = GregorianCalendar.getInstance();
//            calPatientReturnDate.set(2010, 6, 1); // July 1, 2010 (month is zero-based)
//            evaluationTreatment.setPatientReturnDate(calPatientReturnDate.getTime());

            // CONDITIONALLY REQUIRED - Referred Back to Attending Doctor Flag (use constant flagN or flagY) - Required if patient-returning value attribute = 'N'
//            evaluationTreatment.setReferredAttendingDoctor(flagN);

            // REQUIRED - Patient (currently) Working Flag (use constant flagN or flagY)
            evaluationTreatment.setPatientWorking(flagN);

            // OPTIONAL - Date patient resumed work of any kind
//            GregorianCalendar calRtwLimitationsDate = GregorianCalendar.getInstance();
//            calRtwLimitationsDate.set(2010, 4, 1); // May 1, 2010 (month is zero-based)
//            evaluationTreatment.setRtwLimitationsDate(calRtwLimitationsDate.getTime());

            // OPTIONAL - Date patient resumed regular work
//            GregorianCalendar calRtwDate = GregorianCalendar.getInstance();
//            calRtwDate.set(2010, 5, 1); // June 1, 2010 (month is zero-based)
//            evaluationTreatment.setRtwDate(calRtwDate.getTime());

            // End of Evaluation/Treatment Data

            // Billing Information

            // Instantiate the Billing Information object
            us.ny.state.wcb.xml.ns.otpt4_1510.Data.BillingInformation billingInformation = objFactory.createDataBillingInformation();

            // Attach it to the data object
            data.setBillingInformation(billingInformation);

            // Now, populate the Billing Information items

            // Diagnosis

            // Loop thru them...there can be up to 4
            for (int j = 0; j < 1; j++) {
              // One set of static data as an example

              // For each diagnosis, instantiate a diagnosis object
              us.ny.state.wcb.xml.ns.otpt4_1510.Data.BillingInformation.Diagnosis diagnosis = objFactory.createDataBillingInformationDiagnosis();

              // Attach it to the Billing Information object
              billingInformation.getDiagnosis().add(diagnosis);

              // Populate the Diagnosis Items

              // REQUIRED - Diagnosis (ICD9) Code
              diagnosis.setDiagnosisCode("195.4");

              // REQUIRED - Diagnosis (ICD9) Description
              diagnosis.setDiagnosisDesc("Upper limb fracture.");
            }

            // Procedures

            // Loop through them...there is no limit on the number of procedures and there must be at least one.
            for (int j = 0; j < 1; j++) {
              // One set of static data as an example

              // Instantiate a Procedure object
              us.ny.state.wcb.xml.ns.otpt4_1510.Data.BillingInformation.Procedure procedure = objFactory.createDataBillingInformationProcedure();

              // Attach it to the Billing Information object
              billingInformation.getProcedure().add(procedure);

              // Populate the Procedure items

              // REQUIRED - Procedure Service From Date (Start Date)
              procedure.setServiceFromDate(new Date()); // Uses the current date for sample simplicity

              // REQUIRED - Procedure Service Through Date (End Date)
              procedure.setServiceThruDate(new Date()); // Uses the current date for sample simplicity

              // OPTIONAL - Procedure Place of Service
//              procedure.setPlaceOfService("");

              // REQUIRED - Procedure Code
              procedure.setProcedureCode("99213");

              // OPTIONAL - Procedure Modifier A
//              procedure.setProcedureModifierA("");

              // OPTIONAL - Procedure Modifier B
//              procedure.setProcedureModifierB("");

              // REQUIRED - Procedure Service Diagnosis Code
              procedure.setServiceDiagnosisCode("1");

              // REQUIRED - Procedure Service Charge Amount
              procedure.setServiceChargeAmount(new Double(20.79));

              // OPTIONAL - Procedure Service Days or Units
//              procedure.setServiceDaysOrUnits("");

              // OPTIONAL - Procedure Service COB
//              procedure.setServiceCob("");

              // REQUIRED - Procedure Service Zip Code
              procedure.setServiceZipCode("12345");
            }

            // End of Billing Information Data

            // Therapist

            // Instantiate the Therapist object
            us.ny.state.wcb.xml.ns.otpt4_1510.Data.Therapist therapist = objFactory.createDataTherapist();

            // Attach it to the data object
            data.setTherapist(therapist);

            // Now, set the Therapist data

            // REQUIRED - Therapist's Profession (use constant professionOccupationTherapist or professionPhysicalTherapist)
            therapist.setProfession(professionOccupationTherapist);

            // OPTIONAL - Preferred Provider Organization Flag (use constant flagN or flagY)
//            therapist.setWcbPpo(flagY);

            // CONDITIONALLY REQUIRED - Therapist's New York State License Number
            // Required when therapist is New York State-licensed.  At least one of nys-license-number and npi-number must be present.
            therapist.setNysLicenseNumber("123456");

            // CONDITIONALLY REQUIRED - Therapist's National Provider Identifier (NPI)
            // Required when therapist is licensed outside of New York State.  Should always be provided when available.
            // At least one of nys-license-number and npi-number must be present.
//            therapist.setNpiNumber("");

            // REQUIRED - Therapist's Federal ID Number

            // First, instantiate Federal ID class
            us.ny.state.wcb.xml.ns.otpt4_1510.Data.Therapist.FederalIdNumber federalIdNumber = objFactory.createDataTherapistFederalIdNumber();

            // Next, attach to the therapist
            therapist.setFederalIdNumber(federalIdNumber);

            // Next, set the Federal ID Number value
            federalIdNumber.setValue("123456789");

            // Lastly, set the Federal ID Type (1=SSN, 2=EIN)
            federalIdNumber.setType(1);

            // OPTIONAL - Patient's Account Number (Therapist's internal account number for the patient)
//            therapist.setPatientAccountNo("");

            // Therapist's Name/Addresses

            // Name and Office Location - Instantiate the Name and Office Location Object
            us.ny.state.wcb.xml.ns.otpt4_1510.Data.Therapist.NameAndOfficeLocation nameAndOfficeLocation = objFactory.createDataTherapistNameAndOfficeLocation();

            // Attach it to the therapist object
            therapist.setNameAndOfficeLocation(nameAndOfficeLocation);

            // Populate Name and Office Location items

            // REQUIRED - Therapist's Last Name
            nameAndOfficeLocation.setLastName("Johnson");

            // REQUIRED - Therapist's First Name
            nameAndOfficeLocation.setFirstName("Robert");

            // OPTIONAL - Therapist's Middle Initial
//            nameAndOfficeLocation.setMiddleInitial("");

            // REQUIRED - Office Location Address Line 1
            nameAndOfficeLocation.setAddr1("123 Fourth St, Suite 102");

            // OPTIONAL - Office Location Address Line 2
//            nameAndOfficeLocation.setAddr2("");

            // REQUIRED - Office Location City
            nameAndOfficeLocation.setCity("Albany");

            // CONDITIONALLY REQUIRED - Office Location State - Required when country is USA
            nameAndOfficeLocation.setState("NY");

            // CONDITIONALLY REQUIRED - Office Location Zip Code - Required when country is USA or Canada
            nameAndOfficeLocation.setZip("12200");

            // CONDITIONALLY REQUIRED - Office Location Country - Required if Zip Code is not present.  If country is not set, USA is assumed.
//            nameAndOfficeLocation.setCountry("");

            // REQUIRED - Office Location Telephone
            nameAndOfficeLocation.setTelephone("5185551212");

            // Billing Address - Instantiate the Billing Address Object
            us.ny.state.wcb.xml.ns.otpt4_1510.Data.Therapist.BillingAddress billingAddress = objFactory.createDataTherapistBillingAddress();

            // Attach it to the therapist object
            therapist.setBillingAddress(billingAddress);

            // Populate Billing Address items

            // REQUIRED - Billing Address, Name Line 1
            billingAddress.setName1("Medical Group LLP");

            // OPTIONAL - Billing Address, Name Line 2
//            billingAddress.setName2("");

            // REQUIRED - Billing Address, Address Line 1
            billingAddress.setAddr1("186 River St");

            // OPTIONAL - Billing Address, Address Line 2
//            billingAddress.setAddr2("");

            // REQUIRED - Billing Address City
            billingAddress.setCity("Troy");

            // CONDITIONALLY REQUIRED - Billing Address State - Required when country is USA
            billingAddress.setState("NY");

            // CONDITIONALLY REQUIRED - Billing Address Zip Code - Required when country is USA or Canada
            billingAddress.setZip("13658");

            // CONDITIONALLY REQUIRED - Billing Address Country - Required if Zip Code is not present.  If country is not set, USA is assumed.
//            billingAddress.setCountry("");

            // OPTIONAL - Billing Address Telephone
//            billingAddress.setTelephone("xxx");

            // REQUIRED - Affirmed By Therapist - Populating this element is the equivalent of signing the document
            therapist.setAffirmedByTherapist("Robert Johnson");

            // End of Therapist Data

            // End of discrete data for OT/PT-4

            // The OT/PT-4 does not require any attachments.  Attachments can be text or binary.
            // For sample purposes, we will generate one of each to demonstrate both.
            // There is no limit on the number of attachments allowed.  The order of attachments will be preserved when they are imported
            // into WCB's data system.

            // Start of Attachments

            // Add one binary attachment

            // Instantiate the binary attachment object
            AttachmentBinary bin = wcbObjFactory.createAttachmentBinary();

            // Add the binary attachment to the current document
            document.getAttachmentTextOrAttachmentBinary().add(bin);

            // Set the binary attachment's attributes

            // REQUIRED - Binary Attachment's MIME Type - Fixed value - only "image/tiff" is currently allowed.
            bin.setContentType("image/tiff");

            // REQUIRED - Binary Attachment's Reference - This is be the name of the file, included with the submission, that contains the actual
            //            binary attachment.
            bin.setRef("im00003.tif"); // The file named 'im00003.tif' would have to be included with the submission

            // Add one text attachment

            // Instantiate the text attachment object
            // A text attachment consists of one or more pages of 56 lines with 100 characters each.  WCB will internally convert each page to an
            // image by printing the lines of text with a fixed space Courier font, so spaces may be used for formatting and this formatting will
            // be preserved.  Blank lines are also allowed.
            AttachmentText txt = wcbObjFactory.createAttachmentText();

            // Add the text attachment to the current document
            document.getAttachmentTextOrAttachmentBinary().add(txt);

            // For sample purposes, create two pages of text

            // Instantiate a page object for page 1 (at least one page is required)
            AttachmentText.Page pg = wcbObjFactory.createAttachmentTextPage();

            // Add page 1 to the text attachment
            txt.getPage().add(pg);

            // Now, add lines of text to page 1 (max of 56 lines per page, max of 100 characters per line)
            // There must be at least one line on each page.
            pg.getLine().add("Patient:");
            pg.getLine().add("Robert Smith");
            pg.getLine().add("4 321st St");
            pg.getLine().add("Albany, NY 12202");
            pg.getLine().add(""); // Blank lines allowed to preserve formatting
            pg.getLine().add("The patient fell at work and broke his arm.  It appears to be healing well.");
            pg.getLine().add("I recommend 8 more weeks be allowed for recovery.  100% recovery is expected.");
            pg.getLine().add("And so on and so forth... (the explanation should be as detailed as possible)");

            // Instantiate a page object for page 2 (we can reuse variable 'pg' since we're done with it)
            pg = wcbObjFactory.createAttachmentTextPage();

            // Add page 2 to the text attachment
            txt.getPage().add(pg);

            // Now, add lines of text to page 2 (max of 56 lines per page, max of 100 characters per line)
            // There must be at least one line on each page.
            pg.getLine().add("This is the second page of the text attachment.");
            pg.getLine().add("<>\"'&");

            // Add unlimited additional pages as required...

            // End of Attachments

            // Population of one OT/PT-4 document is complete
            break;
          }
        }
      }

      // Using the java structures, populated above, we will now write the corresponding XML file to System.out

      // Create a Marshaller
      JAXBContext jc = JAXBContext.newInstance("us.ny.state.wcb.xml.ns.wcb");
      Marshaller m = jc.createMarshaller();

      // Set property to format output into so it's easily readable
      m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);

      // Next statement sets the schema
      m.setProperty(m.JAXB_SCHEMA_LOCATION, "http://www.wcb.state.ny.us/xml/ns/wcb http://www.wcb.ny.gov/xml/schema/xfs-cis.xsd");

      // Strictly speaking, this next statement isn't necessary, but it makes the namespaces appear more readable
      m.setProperty("com.sun.xml.bind.namespacePrefixMapper",
                    new NamespacePrefixMapperImpl());

      // Output XML to System.out
      m.marshal(sub, System.out);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }
}
